/*****************************************************************************/
/*
   main.cpp
   www.xbdev.net
   Simple Cg demo with DirectX
   Directx9, Windows, Cg

*/
/*****************************************************************************/

//-----------------------------------------------------------------------------
#define STRICT
#define WIN32_LEAN_AND_MEAN

#pragma comment(lib, "cg.lib")
//#pragma comment(lib, "CgFXParser.lib")
// cgGL.lib, cgD3D8.lib
#pragma comment(lib, "cgD3D9.lib")

#pragma comment(lib, "d3dx9.lib")
#pragma comment(lib, "d3d9.lib")

#include <windows.h>
#include <assert.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <Cg/Cg.h>
#include <Cg/CgD3D9.h>

#include "teapot_data.h"

/*****************************************************************************/
// GLOBALS
/*****************************************************************************/
HWND                    g_hWnd          = NULL;
LPDIRECT3D9             g_pD3D          = NULL;
LPDIRECT3DDEVICE9       g_pd3dDevice    = NULL;
LPDIRECT3DTEXTURE9      g_pTexture      = NULL;

LPDIRECT3DVERTEXDECLARATION9 g_pVertexDeclaration = NULL;



//-----------------------------------------------------------------------------
// PROTOTYPES
//-----------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
                   LPSTR lpCmdLine, int nCmdShow);
LRESULT CALLBACK WindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

void init(void);       // 1st - Called once at the start
void render(void);     // 2nd - Over and over again, main render loop
void shutDown(void);   // 3rd - Called once at the end of program

//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: The application's entry point
//-----------------------------------------------------------------------------
int WINAPI WinMain( HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR     lpCmdLine,
                    int       nCmdShow )
{
    WNDCLASSEX winClass; 
    MSG        uMsg;

    memset(&uMsg,0,sizeof(uMsg));

	
	char szClss[] = "windows_clss";
	char szWhat[] = "Sweet but Simple CG Demo....";

    winClass.lpszClassName = szClss;
    winClass.cbSize        = sizeof(WNDCLASSEX);
    winClass.style         = CS_HREDRAW | CS_VREDRAW;
    winClass.lpfnWndProc   = WindowProc;
    winClass.hInstance     = hInstance;
    winClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    winClass.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);
    winClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    winClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
    winClass.lpszMenuName  = NULL;
    winClass.cbClsExtra    = 0;
    winClass.cbWndExtra    = 0;

    if( !RegisterClassEx(&winClass) )
        return E_FAIL;

    g_hWnd = CreateWindowEx( NULL, szClss, 
                             szWhat,
                             WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                             0, 0, 640, 480, NULL, NULL, hInstance, NULL );

    if( g_hWnd == NULL )
        return E_FAIL;

    ShowWindow( g_hWnd, nCmdShow );
    UpdateWindow( g_hWnd );

    init();

    while( uMsg.message != WM_QUIT )
    {
        if( PeekMessage( &uMsg, NULL, 0, 0, PM_REMOVE ) )
        {
            TranslateMessage( &uMsg );
            DispatchMessage( &uMsg );
        }
        else
            render();
    }

    shutDown();

    UnregisterClass( szClss, winClass.hInstance );

    return (int)uMsg.wParam;
}



LRESULT CALLBACK WindowProc( HWND   hWnd, 
                             UINT   msg, 
                             WPARAM wParam, 
                             LPARAM lParam )
{   
    switch( msg )
    {

        case WM_CLOSE:
        {
            PostQuitMessage(0); 
        }
        
        case WM_DESTROY:
        {
            PostQuitMessage(0);
        }
        break;

        default:
        {
            return DefWindowProc( hWnd, msg, wParam, lParam );
        }
        break;
    }

    return 0;
}

//-----------------------------------------------------------------------------
// Name: init()
// Desc: 
//-----------------------------------------------------------------------------
void init( void )
{
    g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );

    D3DDISPLAYMODE d3ddm;

    g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm );

    D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory( &d3dpp, sizeof(d3dpp) );

    d3dpp.Windowed               = TRUE;
    d3dpp.SwapEffect             = D3DSWAPEFFECT_DISCARD;
    d3dpp.BackBufferFormat       = d3ddm.Format;
    d3dpp.EnableAutoDepthStencil = TRUE;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
    d3dpp.PresentationInterval   = D3DPRESENT_INTERVAL_IMMEDIATE;

    g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
                          D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                          &d3dpp, &g_pd3dDevice );
    

    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    //g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
	g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);


	g_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	g_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	g_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

    // Create a texture to test out our pixel shader...
    D3DXCreateTextureFromFile( g_pd3dDevice, "image.bmp", &g_pTexture );
}


//-----------------------------------------------------------------------------
// Name: shutDown()
// Desc: Releases all previously initialized objects
//-----------------------------------------------------------------------------
void shutDown( void )
{
    if( g_pTexture != NULL ) 
        g_pTexture->Release(); 

    if( g_pd3dDevice != NULL )
        g_pd3dDevice->Release();

    if( g_pD3D != NULL )
        g_pD3D->Release();
}


/*
static void advanceAnimation(void)
{
  myEyeAngle += 0.05f;
  if (myEyeAngle > 2*3.14159)
    myEyeAngle -= 2*3.14159;
  //glutPostRedisplay();
}
*/


/*****************************************************************************/
/*                                                                           */
/* render()                                                                  */
/*                                                                           */
/* Called from our main program loop over and over again to render our scene */
/* and of course in this case, the render loop updates things etc...all in   */
/* one loop...probably should be called mainloop() :)                        */
/*                                                                           */
/*****************************************************************************/
void render( void )
{


	/*Lets shade it!*/
    //~1
    CGcontext my_CGcontext = cgCreateContext();     // Create our Cg Context!

	cgD3D9SetDevice(NULL);
    cgD3D9SetDevice( g_pd3dDevice );     // Give Cg, the dx device where using

    // Get vertex and pixel handles!
    CGprofile vertexProfile = cgD3D9GetLatestVertexProfile(); 
    CGprofile pixelProfile  = cgD3D9GetLatestPixelProfile();

    // The real work!  LOAD V.SHADER CG PROGRAM
    CGprogram my_CGprogram_vertex = cgCreateProgramFromFile( my_CGcontext,
                                                  CG_SOURCE,
                                                  "torus_vs.cg",
                                                  vertexProfile,
                                                  "main",
                                                  //vertexOptions );
												  (const char**)0);
    // Now, LOAD OUR P.SHADER CG PROGRAM
    CGprogram my_CGprogram_pixel = cgCreateProgramFromFile( my_CGcontext,
                                                 CG_SOURCE,
                                                 "pixel_shader.cg",
                                                 pixelProfile,
                                                 "main",
                                                 NULL  );

	// Need to describe our data
    D3DVERTEXELEMENT9 declaration[] =
    {
        { 0, 0*sizeof(float),  D3DDECLTYPE_FLOAT4,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
		//{ 0, 3*sizeof(float),  D3DDECLTYPE_FLOAT3,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0 },
        //{ 0, 6*sizeof(float),  D3DDECLTYPE_D3DCOLOR, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_COLOR,    0 },
        //{ 0, 16, D3DDECLTYPE_FLOAT2,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
        D3DDECL_END()
    };


	if( my_CGprogram_pixel == NULL )
	{
		MessageBox(NULL, cgGetErrorString(cgGetError()), "ERROR Loading Pixel Shader", 0);
	}

	// Error Checking!... will it work with our shader?...need to do lots of checking
	// with shaders because of all the different graphics cards..ackkk
    assert(cgD3D9ValidateVertexDeclaration( my_CGprogram_vertex, declaration ));

    g_pd3dDevice->CreateVertexDeclaration( declaration, &g_pVertexDeclaration );
    
	// Basically, we have our Cg program - this compiles it and puts it in memory ready
	// to use :)
    cgD3D9LoadProgram( my_CGprogram_vertex, TRUE, 0 );
    cgD3D9LoadProgram( my_CGprogram_pixel, TRUE, 0 );


	// We need to get handles to the variables we use in our Cg programs, so we can
	// set there values!  Bind them to names :)
    //CGparameter my_CGparam_worldViewProj = cgGetNamedParameter( my_CGprogram_vertex, "worldViewProj" );
    CGparameter my_CGparam_testTexture   = cgGetNamedParameter( my_CGprogram_pixel, "testTexture" );


	CGparameter myCgVertexParam_lightPosition = cgGetNamedParameter(my_CGprogram_vertex, "lightPosition");
    CGparameter myCgVertexParam_eyePosition =cgGetNamedParameter(my_CGprogram_vertex, "eyePosition");
    CGparameter my_CGparam_worldViewProj = cgGetNamedParameter(my_CGprogram_vertex, "modelViewProj");
	CGparameter myCgVertexParam_torusInfo = cgGetNamedParameter(my_CGprogram_vertex, "torusInfo");


		
	const float outerRadius = 6, innerRadius = 2;
	const int columns = 20, rows = 40;
	const float eyeRadius = 18.0;
	const float eyeElevationRange = 8.0;
	
	D3DXVECTOR3 eyePosition;
	static float myEyeAngle = 0;
    
	eyePosition.x = eyeRadius * sin(myEyeAngle);
	eyePosition.y = eyeElevationRange * sin(myEyeAngle);
	eyePosition.z = eyeRadius * cos(myEyeAngle);


	// Clear our dx buffer
    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
                         D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,1.0f), 1.0f, 0 );

    g_pd3dDevice->BeginScene();


    /*Use our VERTEX shaders!...put some data in them, constants, matrices etc*/
    D3DXMATRIX matTrans;
    D3DXMATRIX matRot;
		
	D3DXMATRIX matProj;

	
    D3DXMatrixPerspectiveFovLH( &matProj, D3DXToRadian( 45.0f ), 
                                640.0f / 480.0f, 0.1f, 500.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );


	float static rr = 0.0f;
	rr += 0.08f;

    D3DXMatrixTranslation( &matTrans, 0.0f, 0.0f, 20.0f );
    D3DXMatrixRotationYawPitchRoll( &matRot, 3.14f/2.0f + rr/*x*/, (3.14f*3.0f)/2.0f + rr/*y*/, 3.14f/2.0f+rr );
    D3DXMATRIX matWorld = matRot * matTrans;

	D3DXMATRIX matView;
    D3DXMatrixIdentity( &matView ); // This sample is not really making use of a view matrix
	
	D3DXMatrixLookAtLH(&matView, &D3DXVECTOR3(0,0,-5), &D3DXVECTOR3(0,0,0), &D3DXVECTOR3(0,1,0));
    //g_pd3dDevice->SetTransform(D3DTS_VIEW, &matView);


    D3DXMATRIX worldViewProj = matWorld * matView * matProj;
    D3DXMatrixTranspose( &worldViewProj, &worldViewProj );

	
	D3DXMATRIX worldViewInv = matWorld * matView;
	D3DXMatrixInverse( &worldViewInv, NULL, &worldViewInv );

	cgD3D9SetUniformMatrix( my_CGparam_worldViewProj, &worldViewProj );
	cgD3D9SetUniform(myCgVertexParam_lightPosition, D3DXVECTOR3(-8, 0, 15) );
	cgD3D9SetUniform(myCgVertexParam_eyePosition, &eyePosition);
	cgD3D9SetUniform(myCgVertexParam_torusInfo, D3DXVECTOR2(outerRadius, innerRadius) );


	// Put data in our PIXEL shader constants
    cgD3D9SetTexture( my_CGparam_testTexture, g_pTexture );

	//------------------------//

    cgD3D9BindProgram( my_CGprogram_vertex );
    cgD3D9BindProgram( my_CGprogram_pixel );

    g_pd3dDevice->SetFVF(NULL);
    g_pd3dDevice->SetVertexDeclaration( g_pVertexDeclaration );


	// Yeah yeah...very bad!...creating and destroying the vertex data
	// in the main loop.  But its just for a demo..basic...simple...
	// all in one place.

	LPDIRECT3DVERTEXBUFFER9 my_pVertexBuffer = NULL;
	

	struct Vertex
	{
		D3DXVECTOR3 vP;
		//D3DXVECTOR3 vN;
		//DWORD argb;

		enum FVF
		{
			FVF_Flags = D3DFVF_XYZ // | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX0
		};
	};


	int numVerts = columns * rows * 2;

	int numTris = numVerts / 2 + columns;

	g_pd3dDevice->CreateVertexBuffer( numVerts * 2 * sizeof(Vertex), D3DUSAGE_WRITEONLY, 
									Vertex::FVF_Flags, D3DPOOL_DEFAULT, 
									&my_pVertexBuffer, NULL );
	void *pVertices = NULL;

	my_pVertexBuffer->Lock( 0, numVerts*sizeof(Vertex), (void**)&pVertices, 0 );
	Vertex * pVert = (Vertex*)pVertices;


	const float m = 1.0f/columns;
	const float n = 1.0f/rows;
	int i, j;

	int k = 0;
	for (i=0; i<columns; i++) 
	{
		for (j=0; j<=rows; j++) 
		{
			pVert[k++].vP = D3DXVECTOR3(i*m, j*n, 0.0f);
			pVert[k++].vP = D3DXVECTOR3((i+1)*m, j*n, 0.0f);
		}//End for j

		pVert[k++].vP = D3DXVECTOR3(i*m, 0, 0);
		pVert[k++].vP = D3DXVECTOR3((i+1)*m, 0, 0);
	}//End for i

	my_pVertexBuffer->Unlock();


    g_pd3dDevice->SetStreamSource( 0, my_pVertexBuffer, 0,sizeof(Vertex) );
    //g_pd3dDevice->DrawPrimitive( D3DPT_LINESTRIP, 0, numTris );
	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, numTris * 2  );
//	g_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, 0, numTris * 2);
	//g_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, numTris);

	g_pd3dDevice->EndScene();

    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );

    my_pVertexBuffer->Release();

	/*Clean up after our shader*/
	//cgD3D9SetDevice(NULL);
    cgDestroyProgram(my_CGprogram_vertex);
    cgDestroyProgram(my_CGprogram_pixel);
    cgDestroyContext(my_CGcontext);
	/*Only a demo!*/

}// End Render()

